#version 330
#extension GL_EXT_gpu_shader4 : enable
//Root branching patternMod01.fsh  by   TLC123
//https://www.shadertoy.com/view/tdV3Dd
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed  //*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

float  smin( float a, float b,float k )
{
    float h =  clamp( 0.5+0.5*(b-a)/k, 0.0, 1.0 ) ;
    return mix( b, a, h ) - k*h*(1.0-h);
} 


float smax(float a, float b, float k)
{
    return smin(a, b, -k);
}

float fu(vec2 uv) {
    uv.y = max(uv.y, (abs(pow(uv.y, 1.68))));
    float y = fract(uv.y);
    float ym = mod(floor(uv.y), 2.);
    float o = pow(2., floor(uv.y));
    float x = fract(ym + (uv.x * o) + o) - 0.5;
    float p = (1.00  - abs(abs(x*1.0) - smoothstep(0.0, 1.,smoothstep(0.0, 1.,y) ) * 0.25));
    p = mix(p, p * p, smoothstep(0.,1.,y  * 1.11) );
    return smax(
            ( uv.y-6.25)*sqrt(uv.y)*.09,
            smin(uv.y-.9,
                (-p+1.00)*(smoothstep(-.75,.0,1./y))*(smoothstep(0.,.5,1./uv.y))
                -(1./pow(uv.y,1.68)*.3)
                //(float((p + abs(.15 / ((uv.y) - 0.5)))
                
                
                //*mix(1. , 1., smoothstep(0.,1.,y * 1.1) )
                //))
                ,0.1),0.1)
    //*(3./uv.y)
    ;
}
 
vec2 pR(inout vec2 p, float a) {
    return cos(a) * p + sin(a) * vec2(p.y, -p.x);
}
void main (void)
//void mainImage(out vec4 fragColor, in vec2 fragCoord) 
{
    // Normalized pixel coordinates (from 0 to 1)
    vec2 uv = gl_FragCoord.xy / iResolution.x - vec2(0.5, 0.15);
    uv *= (4.8 + sin(iTime*.2) * 3.);
    uv += vec2(sin(iTime * .17) * 2., cos(iTime * .13) * 2.);
    
    float d=fu(vec2(atan(uv.y, uv.x) / 6.28 * ((2.5)),
                0.6 * length(uv) + .65
            )) ; 
    // coloring
    vec3 col = vec3(1.0) - sign(d) * vec3(0.1, 0.4, 0.7);
    col *= 1.0 - exp(-2.0 * abs(d));
    col *= 0.8 + 0.2 * cos(128.0 * abs(d));
    col = mix(col, vec3(1.0), 1.0 - smoothstep(0.0, 0.015, abs(d)));


    gl_FragColor = vec4(col, 1.0);
}
